<?php
declare(strict_types=1);
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';

function ensure_session(): void {
  if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_start();
  }
  if (REQUIRE_HTTPS && (!isset($_SERVER['HTTPS']) || $_SERVER['HTTPS'] === 'off')) {
    http_response_code(403);
    exit('HTTPS gerekli.');
  }
}

function csrf_token(): string {
  ensure_session();
  if (empty($_SESSION['csrf'])) {
    $_SESSION['csrf'] = bin2hex(random_bytes(16));
  }
  return $_SESSION['csrf'];
}

function csrf_verify(): void {
  ensure_session();
  $t = $_POST['csrf'] ?? '';
  if (!$t || !hash_equals($_SESSION['csrf'] ?? '', $t)) {
    http_response_code(400);
    exit('CSRF hatasi.');
  }
}

function require_login(): void {
  ensure_session();
  if (empty($_SESSION['uid'])) {
    header('Location: login.php');
    exit;
  }
}

function current_user(): ?array {
  ensure_session();
  if (empty($_SESSION['uid'])) return null;

  $stmt = db()->prepare("SELECT id, username, department, role FROM users WHERE id=? AND is_active=1");
  $stmt->execute([$_SESSION['uid']]);
  $u = $stmt->fetch();
  return $u ?: null;
}
