<?php
declare(strict_types=1);
require_once __DIR__ . '/auth.php';
require_login();
csrf_verify();

$u = current_user();
if (!$u) { header('Location: logout.php'); exit; }

$id = (int)($_POST['id'] ?? 0);
if ($id <= 0) exit('Hatalı id.');

if ($u['role'] === 'admin') {
  $stmt = db()->prepare("DELETE FROM events WHERE id=?");
  $stmt->execute([$id]);
} else {
  $stmt = db()->prepare("DELETE FROM events WHERE id=? AND created_by=?");
  $stmt->execute([$id, $u['id']]);
}

header('Location: dashboard.php');
exit;
