<?php
declare(strict_types=1);
require_once __DIR__ . '/auth.php';
require_login();
csrf_verify();

$u = current_user();
if (!$u) { header('Location: logout.php'); exit; }

$title = trim((string)($_POST['title'] ?? ''));
$event_type = (string)($_POST['event_type'] ?? 'Diger');
$location = trim((string)($_POST['location'] ?? ''));
$start_at = (string)($_POST['start_at'] ?? '');
$end_at = (string)($_POST['end_at'] ?? '');

if ($title === '' || $location === '' || $start_at === '' || $end_at === '') {
  exit('Eksik alan.');
}

$start = date('Y-m-d H:i:s', strtotime($start_at));
$end   = date('Y-m-d H:i:s', strtotime($end_at));

if (strtotime($end) <= strtotime($start)) {
  exit('Bitiş, başlangıçtan sonra olmalı.');
}

$allowed = ['Toplanti','Acilis','Konser','Seminer','Saha Calismasi','Diger'];
if (!in_array($event_type, $allowed, true)) $event_type = 'Diger';

$stmt = db()->prepare("
  INSERT INTO events (created_by, department, title, event_type, location, start_at, end_at)
  VALUES (?, ?, ?, ?, ?, ?, ?)
");
$stmt->execute([
  $u['id'],
  $u['department'],
  $title,
  $event_type,
  $location,
  $start,
  $end
]);

header('Location: dashboard.php');
exit;
