<?php
declare(strict_types=1);
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/config.php';

$ym = $_GET['ym'] ?? date('Y-m');
if (!preg_match('/^\d{4}-\d{2}$/', $ym)) $ym = date('Y-m');

$start = $ym . '-01 00:00:00';
$end = date('Y-m-01 00:00:00', strtotime($start . ' +1 month'));

$stmt = db()->prepare("
  SELECT id, department, title, event_type, location, start_at, end_at
  FROM events
  WHERE start_at >= ? AND start_at < ?
  ORDER BY start_at ASC
");
$stmt->execute([$start, $end]);
$events = $stmt->fetchAll();

$prev = date('Y-m', strtotime($start . ' -1 month'));
$next = date('Y-m', strtotime($start . ' +1 month'));
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <title><?= htmlspecialchars(APP_NAME) ?></title>
  <link rel="stylesheet" href="assets/style.css">
</head>
<body>
  <div class="header">
    <div>
      <h2 style="margin:0;"><?= htmlspecialchars(APP_NAME) ?></h2>
      <small>Şifresiz görüntüleme • Amaç: telefonda doğru bilgi</small>
    </div>
    <div>
      <a class="card" style="padding:8px 12px;display:inline-block" href="login.php">Giriş</a>
    </div>
  </div>

  <div class="card">
    <div class="row" style="align-items:center;justify-content:space-between">
      <div>
        <a href="?ym=<?= $prev ?>">&larr; Önceki</a>
        <span style="margin:0 10px;font-weight:700;"><?= htmlspecialchars($ym) ?></span>
        <a href="?ym=<?= $next ?>">Sonraki &rarr;</a>
      </div>
      <form method="get">
        <input name="ym" value="<?= htmlspecialchars($ym) ?>" placeholder="YYYY-AA (örn 2025-12)" />
        <button type="submit">Git</button>
      </form>
    </div>
  </div>

  <div class="card">
    <table>
      <thead>
        <tr>
          <th>Tarih/Saat</th>
          <th>Müdürlük</th>
          <th>Tür</th>
          <th>Etkinlik</th>
          <th>Yer</th>
        </tr>
      </thead>
      <tbody>
      <?php if (!$events): ?>
        <tr><td colspan="5"><small>Bu ay için kayıt yok.</small></td></tr>
      <?php else: foreach ($events as $e): ?>
        <tr>
          <td><?= htmlspecialchars(date('d.m.Y H:i', strtotime($e['start_at']))) ?>
            <small>– <?= htmlspecialchars(date('H:i', strtotime($e['end_at']))) ?></small>
          </td>
          <td><?= htmlspecialchars($e['department']) ?></td>
          <td><span class="badge"><?= htmlspecialchars($e['event_type']) ?></span></td>
          <td><?= htmlspecialchars($e['title']) ?></td>
          <td><?= htmlspecialchars($e['location']) ?></td>
        </tr>
      <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>

  <small>Not: Bu ekran şifresizdir. Düzenleme için giriş gerekir.</small>
</body>
</html>
